<?php
/*
Plugin Name: DIVI Social
Version: 2.0
Plugin URI: https://www.simpmarketing.com/divi-social
Description: Add Social icons to divi header and footer.
Author: SIMP Marketing
Author URI: https://www.simpmarketing.com
*/

// Signal that SDK was initiated.
do_action( '_divisocial_loaded' );
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
require_once('wp-updates-plugin.php');
new WPUpdatesPluginUpdater_1968( 'http://wp-updates.com/api/2/plugin', plugin_basename(__FILE__));
add_action('admin_menu', 'register_setting_page');

function register_setting_page() {
	add_menu_page(
		'DIVI Social', 
		'DIVI Social', 
		'manage_options', 
		'Divi-Social', 
		'DIVI_social',
		'dashicons-share'
	);
}
function DIVI_social(){
	?>
	<div style="text-align:center;">
		<h1>DIVI Social</h1>

		<p>Visit our <a href="https://www.simpmarketing.com/divi-social/" target="_blank">Tutorial</a> Page for help.</p>
		<p>Visit Developer's website : <a href="https://www.simpmarketing.com" target="_blank">Simp Marketing</a></p>
		<p>Need a New Icon? <a href="https://www.simpmarketing.com/contact-us-divi-social-icon-request/">let us know</a> and we will add new icons.</p>
	</div>
	<?php
}

if (!function_exists('et_load_core_options')) {
	function et_load_core_options() {
		global $shortname, $themename;
		require_once get_template_directory() . esc_attr( "/options_{$shortname}.php" );

		$newOptions = [];
		$i=array();
		if (isset($options)) {
			foreach ($options as $i => $optionArray) {
				$newOptions[] = $optionArray;
				if (isset($optionArray['id']) && $optionArray['id'] == 'divi_show_google_icon') {

					include plugin_dir_path(__FILE__) . 'socialnetworks.php';

					foreach ($social_networks as $network) {

						# 3/20/2019 - NOTE: $vis_compat is for some really weird backward compatibility...
						# Most names are divi_show_NETWORK_icon. This accounts for the names that were missing _show_
						# e.g. divi_NETWORK_icon
						# What this does is copies the old setting to the new one IF a new setting doesn't exist.
						$vis_compat = et_get_option('divi_' . $network['key'] . '_icon', 'xxxx');
						if ($vis_compat === "on") {
							$switch_default_position = "on";
						}
						else {
							# Default
							$switch_default_position = "false";
						}

						# On/Off switch
						$newOptions[] = array(
							"name"	=> esc_html__("Show " . $network['name'] . " Icon", $themename),
							"id"	=> $shortname."_show_" . $network['key'] . "_icon",
							"type"	=> "checkbox2",
							"std"	=> $switch_default_position,
							"desc"	=> esc_html__("Here you can choose to display the " . $network['name'] . " Icon. ", $themename)
						);

						# URL textbox
						$newOptions[] = array("name" =>esc_html__($network['name'] . " Profile URL", $themename),
							"id"	=> $shortname."_" . $network['key'] . "_url",
							"std"	=> "#",
							"type"	=> "text",
							"validation_type" => "url",
							"desc"	=> esc_html__("Enter the URL of your " . $network['name'] . " Profile.", $themename));
					}

					$newOptions[] = array(
						"name" =>esc_html__( "Show Icon name on hover", $themename ),
						"id" => $shortname."_show_icon_name_on_hover",
						"type" => "checkbox2",
						"std" => "on",
						"desc" =>esc_html__( "Turn this option on if you want to Show Icon name on hover. ", $themename ) );
					
					$newOptions[] = array(
						"name" =>esc_html__( "Open Icon in new tab", $themename ),
						"id" => $shortname."_open_icon_in_new_tab",
						"type" => "checkbox2",
						"std" => "on",
						"desc" =>esc_html__( "Turn this option on if you want to open Social Icons in new tab ", $themename ) );
					
				}

			}
			$options = $newOptions;
		}
	}
}
if (!function_exists('replace_social_icons')) {
	function replace_social_icons() { 
					include plugin_dir_path(__FILE__) . 'socialnetworks.php';
		?>
		<ul id="new-icons">
			<?php if ( 'on' === et_get_option( 'divi_show_facebook_icon', 'on' ) ) : ?>
				<span class="et-social-icon">
					<a href="<?php echo esc_url( et_get_option( 'divi_facebook_url', '#' ) ); ?>" class="icon">
						<li class="fab fa-facebook-f   tooltip">
							<span class="tooltiptext"><?php esc_html_e( 'Facebook', 'Divi' ); ?></span>
						</li>
					</a>
				</span>
			<?php endif; ?>

			<?php if ( 'on' === et_get_option( 'divi_show_twitter_icon', 'on' ) ) : ?>
				<span class="et-social-icon">
					<a href="<?php echo esc_url( et_get_option( 'divi_twitter_url', '#' ) ); ?>" class="icon">
						<li class="fab fa-twitter    tooltip">	
							<span class="tooltiptext"><?php esc_html_e( 'Twitter', 'Divi' ); ?></span>
						</li>
					</a>
				</span>
			<?php endif; ?>

			<?php if ( 'on' === et_get_option( 'divi_show_google_icon', 'on' ) ) : ?>
				<span class="et-social-icon">
					<a href="<?php echo esc_url( et_get_option( 'divi_google_url', '#' ) ); ?>" class="icon">
						<li class="fab fa-google-plus   tooltip">	
							<span class="tooltiptext"><?php esc_html_e( 'Google', 'Divi' ); ?></span>
						</li>
					</a>
				</span>
			<?php endif; ?>

			<?php if ( 'on' === et_get_option( 'divi_show_rss_icon', 'on' ) ) : ?>
				<?php
				$et_rss_url = '' !== et_get_option( 'divi_rss_url' )
					? et_get_option( 'divi_rss_url' )
					: get_bloginfo( 'rss2_url' );
				?>
				<span class="et-social-icon">
					<a href="<?php echo esc_url( $et_rss_url ); ?>" class="icon">
						<li class="fa fa-rss    tooltip">
							<span class="tooltiptext"><?php esc_html_e( 'RSS', 'Divi' ); ?></span>
						</li>
					</a>
				</span>
			<?php endif; ?>

			<!-- Custom icons -->
			<?php

			# Icons are defined in socialnetworks.php
			include plugin_dir_path(__FILE__) . 'socialnetworks.php';

			# Loop through each one and generate the HTML
			foreach ($social_networks as $network) {

				# Is this icon visible?
				$show_icon = et_get_option('divi_show_' . $network['key'] . '_icon', 'xxxx');
				$visible = ($show_icon === 'on');

				# 'xxxx' means there was no value in the system. So we might need to use the old value
				if ($show_icon === 'xxxx') {
					# 
					# NOTE: $vis_compat is for some really weird backward compatibility...
					# Most names are divi_show_NETWORK_icon. This accounts for the names that were missing _show_
					# e.g. divi_NETWORK_icon
					# This will probably be phased out in a future version
					$vis_compat = et_get_option('divi_' . $network['key'] . '_icon', 'xxxx'); # xxxx is default. If this returns default, then ignore it.
					if ($vis_compat !== "xxxx") { # If it's not xxxx then it's a real value.
						$visible = ($vis_compat === "on"); # Compare against $vis_compat instead of the option above it
					}
				}
				# /End compatibility

				if ($visible):
					?>
					<span class="et-social-icon">
						<a href="<?php echo esc_url(et_get_option('divi_' . $network['key'] . '_url', '#')); ?>" class="icon">
							<li class="<?php echo $network['fa_class']; ?> tooltip">
								<span class="tooltiptext"><?php esc_html_e($network['name'], 'Divi'); ?></span>
							</li>
						</a>
					</span>
					<?php
				endif;
			}
			?>
			<!-- Custom icons -->

			<?php if ( 'on' === et_get_option( 'divi_open_icon_in_new_tab', 'on' ) ) : ?>   
				<script>
					jQuery(document).ready(function($){
						$('.icon').each(function(){
							$(this).attr('target', 'blank');
						});
					});
				</script>
			<?php endif; ?> 
				
			<?php if ( 'on' !== et_get_option( 'divi_show_icon_name_on_hover', 'on' ) ) : ?> 
				<style>.tooltiptext{display:none !important;}</style>
			<?php endif; ?>  

			<?php if ( 'on' === et_get_option( 'divi_show_icon_name_on_hover', 'on' ) ) : ?>   
				<style>
					.tooltip {
						position: relative;
						display: inline-block;
					}
					.tooltip .tooltiptext {
						visibility: hidden;
						width: 120px;
						font-size:12px;
						background-color: black;
						color: #fff;
						text-align: center;
						border-radius: 6px;
						padding: 5px 0;
						/* Position the tooltip */
						position: absolute;
						z-index: 1;
						top: 100%;
						left: 50%;
						margin-left: -60px;
					}
					#footer-bottom span.tooltiptext {
						position: absolute;
						z-index: 1;
						top: -37px;
						left: -10px;
						visibility: hidden;
						width: 120px;
						font-size:12px;
						background-color: black;
						color: #fff;
						text-align: center;
						border-radius: 6px 0px;
						padding: 5px 0;
					}

					#footer-bottom .tooltip:hover .tooltiptext , .tooltip:hover .tooltiptext {
						visibility: visible;
					}
					.et-social-icon:hover span{display: block;}
				</style>
			<?php endif; ?>
		</ul>

		<!-- Push New List -->
		<script>
			jQuery(function($){
				// Above header - Added inside #main-header wrap
				$('.et-social-icons').empty();
				$('#new-icons').contents().appendTo('.et-social-icons');
			});
		</script>

		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css" integrity="sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU" crossorigin="anonymous">
		<?php
	}
}
add_action('wp_footer', 'replace_social_icons');